/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.standalone;

import frc.emul.api.engine.IEngine;
import frc.emul.config.Configuration;
import frc.emul.util.Utils;
import frc.emul.vectrex.Vectrex;
import frc.emul.version.Version;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class StandaloneEngine
implements IEngine {
    private Vectrex vectrex;
    private RunEngineThread worker;
    private boolean systemLoaded;

    public StandaloneEngine(Configuration configuration) {
        this.vectrex = new Vectrex(configuration);
        this.worker = new RunEngineThread(this.vectrex);
    }

    public void loadSystemROM(InputStream inputStream) throws IOException {
        this.vectrex.loadSystemROM(inputStream);
        this.systemLoaded = true;
    }

    public void loadCartridgeROM(InputStream inputStream) throws IOException {
        this.vectrex.loadCartridgeROM(inputStream);
    }

    public final void defineCartridgeRAM(int n, int n2) {
        this.vectrex.defineCartridgeRAM(n, n2);
    }

    public void runVM() {
        if (!this.systemLoaded) {
            throw new IllegalStateException("System ROM is not loaded!");
        }
        this.vectrex.initialise();
        this.worker.start();
    }

    public Vectrex getCore() {
        return this.vectrex;
    }

    static class RunEngineThread
    extends Thread {
        private Vectrex core;
        private boolean terminating;
        private int returnCode;

        RunEngineThread(Vectrex vectrex) {
            this.core = vectrex;
            this.setName("ParaJVE - VM Engine");
            this.setPriority(4);
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public boolean isTerminating() {
            return this.terminating;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void terminate(boolean bl) {
            if (!this.isAlive()) {
                return;
            }
            this.terminating = true;
            this.core.terminate();
            if (!bl) return;
            RunEngineThread runEngineThread = this;
            synchronized (runEngineThread) {
                while (true) {
                    if (!this.isAlive()) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void run() {
            boolean bl;
            Throwable throwable = null;
            try {
                bl = this.core.exec();
                this.returnCode = bl ? 0 : -1;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                bl = false;
                this.returnCode = -2;
            }
            if (!bl) {
                System.out.println("*** SIMULATION ENDED ON ERROR");
                try {
                    Utils.dumpProc(this.core.getCPU(), false);
                    Utils.dumpStack(this.core.getCPU(), 20);
                }
                catch (Throwable throwable3) {}
                if (throwable != null) {
                    throwable.printStackTrace(System.out);
                }
                String string = null;
                try {
                    File file = this.core.dumpState("error_", true, true, true);
                    if (file != null) {
                        string = Utils.getRelativePath(file);
                        System.out.println("*** Core dumped to [" + string + "]");
                    }
                }
                catch (Throwable throwable4) {
                    System.err.println("*** Error while dumping core :");
                    throwable4.printStackTrace();
                }
                this.displayError(string);
            } else {
                System.out.println("*** SIMULATION ENDED SUCCESSFULLY");
            }
        }

        private void displayError(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string2 = "<html><font color=#C00000><b>An error occured in ParaJVE's emulation core.</b><br>The execution cannot recover, and the engine is now stopped.</font><br>";
                    if (string != null) {
                        string2 = String.valueOf(string2) + "<br><hr>An error report has been generated in the file :<br><b>" + string + "&nbsp;</b><br><br>" + "This file contains ParaJVE informations only, please send it at<br>" + "&lt;<font color=#2020FF>" + Version.getContactEmail() + "</font>&gt; in order to help this issue to be fixed!&nbsp;<br>";
                    }
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, string2, "ParaJVE Error", 0);
                }
            });
        }
    }
}

